require( "scripts/style.lua" );

gCurScreen = 0;

function SetScreen( screen )

	if screen == 0 then
		screen = 4;
	elseif screen == 5 then
		screen = 1;
	end

	if screen == 1 then
		EnableWindow("helptext1",true)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",false)
		EnableWindow("helptext4",false)
	elseif screen == 2 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",true)
		EnableWindow("helptext3",false)
		EnableWindow("helptext4",false)
	elseif screen == 3 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",true)
		EnableWindow("helptext4",false)
	elseif screen == 4 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",false)
		EnableWindow("helptext3",false)
		EnableWindow("helptext4",true)
	end

	gCurScreen = screen ;
end

LeftButtonGraphics = {
	"buttons/arrowleft_up",
	"buttons/arrowleft_down",
	"buttons/arrowleft_over"
};

RightButtonGraphics = {
	"buttons/arrowright_up",
	"buttons/arrowright_down",
	"buttons/arrowright_over"
};

HelpTitleFont = {
  standardFont,
  35,
  BlackColor
};

HelpSubTitleFont = {
  standardFont,
  30,
  BlackColor
};

HelpTextFont = {
  standardFont,
  18,
  BlackColor
};

HelpTitleTextStyle = 
{
	parent = DialogBodyText,
	font = HelpTitleFont,
	x = kCenter,
	y = 26,
	w = 100,
	h = 50,
};

HelpSubTitleTextStyle = 
{
	parent = DialogBodyText,
	font = HelpSubTitleFont,
	x = kCenter,
	y = 26,
	w = 100,
	h = 50,
};

TextStyle=
{
	parent=DialogBodyText,
	font = HelpTextFont,
	x=95,y=50,w=kMax-110,h=kMax-80,
	flags = kHAlignLeft+ kVAlignTop,
};
CloseButtonStyle = 
{
	parent = ThinButtonStyle,
	label="close",
	name="close",
	cancel=true,
	x=kMax-200,y=kMax-55,
	command=function() CloseWindow(); end;
};
NextButtonStyle = 
{
	parent = ThinButtonStyle,
	graphics = RightButtonGraphics,
	label="",
	name="next",
	default=true,
	x=kCenter+130,y=kMax-45,
	command=function() SetScreen( gCurScreen+1 ); end;
};
PreviousButtonStyle = 
{
	parent = ThinButtonStyle,
	graphics = LeftButtonGraphics,
	label="",
	name="previous",
	default=false,
	align=kHAlignRight+kVAlignBottom,
	x=kCenter-140,y=kMax-45,
	command=function() SetScreen( gCurScreen-1 ); end;
};

NextButtonTextStyle=
{
	parent=DialogBodyText,
	x=kCenter+120,y=kMax-80,
	w=100,h=25,
	flags = kHAlignLeft+ kVAlignTop,
};
PreviousButtonTextStyle=
{
	parent=DialogBodyText,
	x=kCenter-65,y=kMax-80,
	w=100,h=25,
	flags = kHAlignLeft+ kVAlignTop,
};

MakeDialog
{
	-- Name the modal dialog
	name="help",
	Bitmap
	{
		image = "backgrounds/fullscreendialog",
		mask = exists("backgrounds/fullscreendialog.mask.png"),
		x=kCenter,
		y=kCenter,

		Window
		{
			name="helptext1",
			w=kMax,h=kMax,

			SetStyle(HelpTitleTextStyle),
			Text
			{
				label = "help",
			},
			
			SetStyle(TextStyle),
			Text
			{
				label="help1",
				x = kCenter+45,
				y = 100,
				w = kMax-90,
				h = 200,
			},
			
			Text
			{
				label = "help2",
				x = kCenter-130,
				y = 200,
				w = 170,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help01_navigation",
				mask = exists("backgrounds/help01_navigation.mask.png");
			},
			
			Text
			{
				label = "help3",
				x = kCenter-210,
				y = 430,
				w = 170,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help02_doorways",
				mask = exists("backgrounds/help02_doorways.mask.png");
			},
			
			Text
			{
				label = "help4",
				x = kCenter+10,
				y = 430,
				w = 170,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help03_talking",
				mask = exists("backgrounds/help03_talking.mask.png");
			},
			
			Text
			{
				label = "help5",
				x = kCenter+230,
				y = 430,
				w = 170,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help04_items",
				mask = exists("backgrounds/help04_items.mask.png");
			},
			
			
			SetStyle(CloseButtonStyle),
			Button
			{
				align=kHAlignLeft+kVAlignBottom,
			},
			SetStyle(NextButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(NextButtonTextStyle),
			Text
			{
				label="next",
			},
		},
		Window
		{
			name="helptext2",
			w=kMax,h=kMax,

			SetStyle(HelpTitleTextStyle),
			Text
			{
				label = "help",
			},
			
			SetStyle(TextStyle),
			Text
			{
				label = "help6",
				x = kCenter+130,
				y = 130,
				w = 300,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help05_inventory",
				mask = exists("backgrounds/help05_inventory.mask.png");
			},
			
			Text
			{
				label = "help7",
				x = kCenter+130,
				y = 275,
				w = 300,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help06_recycling",
				mask = exists("backgrounds/help06_recycling.mask.png");
			},
			
			Text
			{
				label = "help8",
				x = kCenter+130,
				y = 400,
				w = 300,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help07_butterflies",
				mask = exists("backgrounds/help07_butterflies.mask.png");
			},
			
			SetStyle(CloseButtonStyle),
			Button
			{
				align=kHAlignLeft+kVAlignBottom,
			},
			SetStyle(NextButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(NextButtonTextStyle),
			Text
			{
				label="next",
			},
			SetStyle(PreviousButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(PreviousButtonTextStyle),
			Text
			{
				label="prev",
			},
		},
		Window
		{
			name="helptext3",
			w=kMax,h=kMax,

			SetStyle(HelpTitleTextStyle),
			Text
			{
				label = "help",
			},
			
			SetStyle(TextStyle),
			Text
			{
				label = "help9",
				x = kCenter-200,
				y = 140,
				w = 230,
			},
			Text
			{
				label = "help10",
				x = kCenter-150,
				y = 390,
				w = 240,
			},
			Text
			{
				label = "help11",
				x = kCenter+120,
				y = 180,
				w = 320,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help08_icons",
				mask = exists("backgrounds/help08_icons.mask.png");
			},
			
			Text
			{
				label = "help12",
				x = kCenter+210,
				y = 310,
				w = 220,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help09_stop",
				mask = exists("backgrounds/help09_stop.mask.png");
			},
			
			SetStyle(CloseButtonStyle),
			Button
			{
				align=kHAlignLeft+kVAlignBottom,
			},
			SetStyle(NextButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(NextButtonTextStyle),
			Text
			{
				label="next",
			},
			SetStyle(PreviousButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(PreviousButtonTextStyle),
			Text
			{
				label="prev",
			},
		},
		Window
		{
			name="helptext4",
			w=kMax,h=kMax,

			SetStyle(HelpTitleTextStyle),
			Text
			{
				label = "help",
			},
			
			SetStyle(HelpSubTitleTextStyle),
			Text
			{
				label = "help13",
				x = kCenter,
				y = 100,
				w = 220,
			},
			
			SetStyle(TextStyle),
			Text
			{
				label = "help14",
				x = kCenter-180,
				y = 370,
				w = 220,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help10_beading",
				mask = exists("backgrounds/help10_beading.mask.png");
			},
			
			SetStyle(TextStyle),
			Text
			{
				label = "help15",
				x = kCenter+140,
				y = 370,
				w = 220,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help11_package",
				mask = exists("backgrounds/help11_package.mask.png");
			},
			
			SetStyle(TextStyle),
			Text
			{
				label = "help16",
				x = kCenter,
				y = 430,
				w = 380,
			},
			Bitmap
			{
				x = 0,
				y = 0,
				image = "backgrounds/help12_arrows",
				mask = exists("backgrounds/help12_arrows.mask.png");
			},
			
			SetStyle(CloseButtonStyle),
			Button
			{
				align=kHAlignLeft+kVAlignBottom,
			},
			SetStyle(PreviousButtonStyle),
			Button
			{
				align=kHAlignRight+kVAlignBottom,
			},
			SetStyle(PreviousButtonTextStyle),
			Text
			{
				label="prev",
			},
		},
	}
}

SetScreen(1);
